#!/usr/bin/env ruby
#
#####################
# Helper function
#####################
def recursiveFileSearch(initialList)
  extraPathList = []
  regexp = /\\(?:include|input)\{([^}]*)\}/   # ?: don't capture group
  visitedFilesList = Hash.new
  tempFileList = initialList.clone
  listToReturn = Array.new
  until (tempFileList.empty?) 
    filename = tempFileList.shift
    # Have we visited this file already?
    unless visitedFilesList.has_key?(filename) then
      visitedFilesList[filename] = filename
      # First, find file's path.
      filepath = File.dirname(filename) + "/"
      File.open(filename) do |file|
        file.each do |line|
          # search for links
          if line.match(regexp) then
            m = $1
            # Need to deal with the case of multiple words here, separated by comma.
            list = m.split(',')
            list.each do |item|
              item.strip!
              # need to look at all paths in extraPathList for the file
              (extraPathList << filepath).each do |path|
                testFilePath = path + if (item.slice(-4,4) != ".#{fileExt}") then item + ".#{fileExt}" else item end
                if File.exist?(testFilePath) then
                  listToReturn << testFilePath
                  if (fileExt == "tex") then tempFileList << testFilePath end
                  if block_given? then 
                    File.open(testFilePath) {|file| yield file}
                  end
                end
              end
            end
          end
        end
      end
    end
  end
  return listToReturn
end
######################
# Program start
######################
#
# Work with the current file; if TM_LATEX_MASTER is set, work with both
# Thanks to Alan Schussman
#
filelist = []
filelist << ENV["TM_FILEPATH"] if ENV.has_key?("TM_FILEPATH")
filelist << ENV["TM_LATEX_MASTER"] if ENV.has_key?("TM_LATEX_MASTER")
# Recursively find all relevant files. Don't forget to include current files
filelist += recursiveFileSearch(filelist)
# Get word prefix to expand
# if !(ENV.has_key?("TM_CURRENT_WORD")) then
# matchregex = /\\#{ENV["TM_CURRENT_WORD"] || ""}\w+/
# end
# Process the filelist looking for all matching commands.
completionslist = DATA.read.split("\n")

filelist.uniq.each {|filename|
  File.open("#{filename}") do |theFile|
    completionslist += theFile.read.scan(/\\([\w@]+)/).map{|i| i[0]}.reject{|i| i.length <= 2}
  end
}
completionslist = completionslist.grep(/^#{ENV['TM_CURRENT_WORD']}/) unless ENV['TM_CURRENT_WORD'].nil?
print completionslist.uniq.sort.join("\n")
__END__
@addtoreset
@afterheading
@afterindentfalse
@beginparpenalty
@biblabel
@cite
@dotsep
@dottedtocline
@endparpenalty
@evenfoot
@evenhead
@float
@gobble
@idxitem
@ifpackagelater
@ifpackageloaded
@ifpackagewith
@include
@itempenalty
@listi
@listii
@listiii
@makecaption
@makefigcaption
@makefnmark
@makefntext
@makeschapterhead
@makewincaption
@mkboth
@oddfoot
@oddhead
@pnumwidth
@preamble
@ptsize
@removefromreset
@seccntformat
@secpenalty
@startsection
@starttoc
@tabacckludge
@tempboxa
@thefnmark
@tocrmarg
@topcaptionfalse
above
abovecaptionskip
abovedisplayshortskip
abovedisplayskip
aboverulesep
abovetopsep
abovewithdelims
abs
abstractname
accent
accentedsymbol
accentset
Acite
acite
acro
active@char
actualchar
acute
add
addcontentsline
adddialect
addlanguage
addlinespace
addpenalty
AddThinSpaceBeforeFootnotes
AddTo
addto
addtocontents
addtocounter
addtolength
addvspace
ADLdrawingmode
advance
AE
ae
afterpage
Ahead
aleph
aliasshorthand
allcaps
allinethickness
allleters
allowdisplaybreaks
allowhyphens
Alph
alph
alpha
Alphfinal
AlsoImplementation
alsoname
AltMacroFont
amalg
anchor
and
andname
angle
answer
Apageref
apageref
Appendix
appendix
appendixname
approx
approxeq
arabic
arc
arccos
arccosh
arcctg
arch
arcsin
arcsinh
arctan
arctanh
arctg
Aref
aref
arg
arraybackslash
arraycolsep
arraylinesep
arrayrulecolor
arrayrulewidth
arraystretch
arrowlength
Arrownot
arrownot
Arrowvert
arrowvert
Asbuk
asbuk
Ask
askforoverwritefalse
askonceonly
AskOptions
ast
asymp
AtBeginDelayedFloats
AtBeginDocument
AtBeginFigures
AtBeginTables
AtEndDocument
AtEndOfClass
AtEndOfPackage
AtForty
athnum
atop
atopwithdelims
author
Az
az
backepsilon
backmatter
backprime
backsim
backsimeq
backslash
balpha
bar
baro
barwedge
BaseDirectory
baselineskip
baselinestretch
batchinput
batchmode
Bbbk
bbl@activate
bbl@allowhyphens
bbl@deactivate
bbl@declare@ttribute
bbslash
bcline
because
begin
begingroup
belowcaptionskip
belowdisplayshortskip
belowdisplayskip
belowrulesep
belowtopsep
beta
beth
between
bfdefault
bfseries
bga
bgroup
bhline
bibAnnotePath
bibansep
bibapifont
bibatsep
bibauthormultiple
bibbdsep
bibbfsasep
bibbfsesep
bibbsasep
bibbstesep
bibbtasep
bibbtesep
bibbtfont
bibcolumnsep
bibdata
bibeansep
bibefnfont
bibelnfont
bibenglish
bibentry
bibfnfont
bibfont
bibhang
bibidemPfname
bibidempfname
bibidemPmname
bibidempmname
bibidemPnname
bibidempnname
bibidemSfname
bibidemsfname
bibidemSmname
bibidemsmname
bibidemSnname
bibidemsnname
bibindent
bibitem
bibjtfont
bibjtsep
bibleftcolumn
bibleftcolumnadjust
bibliography
bibliographylatex
bibliographystyle
bibliographystylelatex
bibliographyunit
biblnfont
bibname
bibnotcited
bibnumfmt
bibpreamble
bibpunct
bibrightcolumn
bibrightcolumnadjust
bibs
bibsall
bibsection
bibsep
bibsgerman
bibstyle
bibtfont
bibtotalpagesname
Bicycle
Big
big
bigbox
bigcap
bigcirc
bigcup
bigcurlyvee
bigcurlywedge
Bigg
bigg
Biggl
biggl
Biggr
biggr
biginterleave
Bigl
bigl
Bigm
bigm
bignplus
bigodot
bigoplus
bigotimes
bigparallel
Bigr
bigr
bigskip
bigskipamount
bigsqcap
bigsqcup
bigstar
bigtriangledown
bigtriangleup
biguplus
bigvee
bigwedge
binampersand
bindnasrepma
binom
blacklozenge
blacksquare
blacktriangle
blacktriangledown
blacktriangleleft
blacktriangleright
bluefbox
bm
bmdefine
bmod
bneg
boldmath
boldsymbol
boolean
born
bot
botfigrule
bothIfFirst
bothIfSecond
botmark
bottomcaption
bottomfraction
bottomrule
bottomtitlespace
bowtie
Box
boxast
boxbar
boxbox
boxbslash
boxcircle
boxdot
boxed
boxempty
boxlength
boxminus
boxplus
boxslash
boxtimes
bpi
bracevert
breve
bsc
bslash
btPrintAll
btPrintCited
btPrintNotCited
bullet
Bumeq
bumeq
BUseVerbatim
BVerbatim
BVerbatimInput
bye
calq
Cancer
Cap
cap
capitalacute
capitalbreve
capitalcaron
capitalcedilla
capitalcircumflex
capitaldieresis
capitaldotaccent
capitalgrave
capitalhungarumlaut
capitalmacron
capitalnewtie
capitaltilde
caps
capsdef
capsreset
capssave
capsselect
caption
captionof
captions
captionsetup
captionsrussian
carriagereturn
catcode
cbcolor
cbdelete
cbend
cbinput
cbstart
ccname
cdashline
cdot
cdots
cellcolor
centerdot
Centering
centering
CenteringLeftskip
CenteringParfillskip
CenteringParindent
CenteringRightskip
centerline
cfoot
cfrac
changebarsep
changebarwidth
changes
chapnumfont
chappgsep
chapter
chapterheadendvskip
chapterheadstartvskip
chaptermark
chaptername
chapterpagestyle
chaptertitlename
CharacterTable
chead
check
CheckCommand
CheckModules
CheckSum
Chi
chi
chunk
circ
circeq
circle
circlearrowleft
circlearrowright
circledast
circledcirc
circleddash
circledS
citation
citationdata
citationstyle
citationsubject
cite
citeA
Citealp
citealp
Citealt
citealt
citeasnoun
Citeauthor
citeauthor
citeauthoryear
citedash
citefield
citeform
citefullfirstfortype
citeindexfalse
citeindextrue
citeindextype
citelatex
citeleft
citemid
CiteMoveChars
citeN
citen
citename
citenotitlefortype
citeNP
citenum
citenumfont
citeonline
Citep
citep
citepalias
citepunct
citeright
citestyle
citeswithoutentry
Citet
citet
citetalias
citetext
citetitle
citetitlefortype
citetitleonly
citeyear
citeyearNP
citeyearpar
ClassError
ClassInfo
ClassWarning
ClassWarningNoLine
cleardoublepage
clearpage
cleartoevenpage
cleartooddpage
cline
closecurve
clubpenalty
clubsuit
cmd
cmdrule
cmidrulekern
cmidrulesep
cmidrulewidth
CodelineFont
CodelineIndex
CodelineNumbered
Coffeecup
colon
color
colorbox
columnbreak
columncolor
columnsep
columnseprule
columnwidth
Com
combinemarks
complement
ComputerMouse
cong
contentsfinish
contentslabel
contentsline
contentsmargin
contentsname
contentspage
contentspush
contentsuse
ContinuedFloat
coprod
copyright
cornersize
cos
cosec
cosh
cot
coth
count
cov
crcr
csc
csname
Csub
ctg
cth
Cube
Cup
cup
curlyeqprec
curlyeqsucc
curlyvee
curlyveedownarrow
curlyveeuparrow
curlywedge
curlywedgedownarrow
curlywedgeuparrow
CurrentOption
currentpage
currenttitle
Curve
curve
curvearrowleft
curvearrowright
CustomVerbatimCommand
CustomVerbatimEnvironment
cyrillicencoding
cyrillictext
dag
dagger
daleth
dasharrow
dashbox
dashleftarrow
dashlength
dashline
dashlinedash
dashlinegap
dashlinestretch
dashrightarrow
dashv
date
datesdmy
datesymd
DavidStar
DavidStarSolid
dbinom
dblfigrule
dblfloatpagefraction
dblfloatsep
dbltextfloatsep
dbltopfraction
ddag
ddagger
ddddot
dddot
ddot
ddots
decaheterov
decimalcomma
decimalpoint
decimalsep
declare@shorthand
DeclareCaptionFormat
DeclareCaptionJustification
DeclareCaptionLabelFormat
DeclareCaptionLabelSeparator
DeclareCaptionListOfFormat
DeclareCaptionStyle
DeclareDir
DeclareDirectory
DeclareEncodingSubset
DeclareErrorFont
DeclareFixedFont
DeclareFontEncoding
DeclareFontEncodingDefaults
DeclareFontFamily
DeclareFontShape
DeclareFontSubstitution
DeclareGraphicsExtensions
DeclareGraphicsRule
DeclareInputMath
DeclareInputText
DeclareMathAccent
DeclareMathAlphabet
DeclareMathDelimiter
DeclareMathOperator
DeclareMathRadical
DeclareMathSizes
DeclareMathSymbol
DeclareMathVersion
DeclareNewFootnote
DeclareOption
declarepostamble
declarepreamble
DeclareRobustCommand
DeclareSymbolFont
DeclareSymbolFontAlphabet
DeclareTextAccent
DeclareTextAccentDefault
DeclareTextCommand
DeclareTextCommandDefault
DeclareTextComposite
DeclareTextCompositeCommand
DeclareTextSymbol
DeclareTextSymbolDefault
DeclareUnicodeCharacter
DeclareUrlCommand
def
defaultaddspace
defaultbibliography
defaultbibliographystyle
DefaultFindent
defaulthyphenchar
DefaultLhand
DefaultLines
DefaultLoversize
DefaultLraise
DefaultNindent
DefaultSlope
defcitealias
define@boolkey
define@cmdkey
pDefineFNsymbols
defineshorthand
DefineShortVerb
DEFlvec
deg
deletebarwidth
DeleteShortVerb
delimitershortfall
Delta
delta
Denarius
depth
DescribeEnv
DescribeMacro
Descriptionlabel
descriptionlabel
det
dfrac
diagdown
diagup
Diamond
diamond
diamondsuit
Digamma
digamma
dim
dimen
ding
dingfill
dingline
DisableCrossrefs
discretionary
displaybreak
displaycaps
displaylimits
displaystyle
div
divide
divideontimes
docdate
DocInclude
DocInput
DocstyleParms
documentclass
documentstyle
dominilof
dominilot
dominitoc
DoNotIndex
DontCheckModules
doparttoc
dosecttoc
dot
Doteq
doteq
doteqdot
dotfill
dotplus
dots
dotsb
dotsc
dotsi
dotsm
dotso
dottedline
doublebox
doublecap
doublecup
DoubleperCent
doublerulesep
doublerulesepcolor
doublespacing
Downarrow
downarrow
downdownarrows
downharpoonright
drawdimensionsfalse
drawdimensionstrue
drawline
drawlinestrech
drawwith
ecaption
edef
editorname
efloatseparator
ega
ell
ellipse
ellipsisgap
ellipsispunctuation
ELSE
em
email
emdash
emergencystrech
eminnershape
emph
emptyset
EnableCrossrefs
encapchar
enclname
encodingdefault
End
end
endbatchfile
endcsname
endfirsthead
endfoot
endgraf
endgroup
endhead
ENDIF
endinput
endlastFont
endnote
endnotemark
endnotetext
endpostamble
endpreamble
eng
enlargethispage
enoteformat
enoteheading
enotesize
enskip
enspace
ensuremath
EPS
epsilon
eqcirc
eqref
eqsim
eqslantless
equal
equiv
eqvref
Esper
esper
esssup
eta
etc
eth
EuFrak
EUR
EURcf
EURcr
EURdig
EURhv
EURO
euro
EUROADD
EURofc
EUROFORMAT
EUROSYM
EURtm
EuScript
evensidemargin
everypar
excludeonly
ExecuteOptions
exists
exp
expandafter
ExplainOptions
ext@figure
ext@table
externaldocument
extracolsep
extrafootnoterule
extraheadheight
extramarks
extrarowheight
extrarulesep
extras
extrasrussian
extratabsurround
eye
EyeDollar
FAIL
FAILa
FAILb
FAILc
FAILd
fakelistoffigures
fakelistoftables
faketableofcontents
fallingdotsep
familydefault
fancyfoot
fancyfootoffset
fancyhead
fancyheadoffset
fancyhf
fancyhfoffset
fancyoval
fancypage
fancypagestyle
fancyput
FancyVerbFormatLine
FancyVerbStartString
FencyVerbStopString
FancyVerbTab
fatbslash
fatsemi
fatslash
Faxmachine
fbox
fboxrule
fboxsep
fcolorbox
fcolwidth
FEMALE
Female
figurename
figureplace
figuresection
filcenter
file
filedate
filename
fileversion
filinner
fill
fillast
filleft
filltype
filouter
filright
Finale
finalhyphendemerits
finallinebreak
Finv
Fire
firsthdashline
firsthline
firstleftmark
firstleftxmark
firstmark
firstrightmark
firstrightxmark
FiveFlowerPetal
Fixedbearing
Flag
flat
FloatBarrier
floatdesign
floatdiagram
floatname
floatpagedesign
floatpagediagram
floatpagefraction
floatplacement
floatsep
floatstyle
flushbottom
flushcolumns
fnref
fnsymbol
font
fontdimen
fontdimen1
fontdimen2
fontdimen3
fontdimen4
fontdimen5
fontdimen6
fontdimen7
fontencoding
fontfamily
fontseries
fontshape
fontsize
Football
footcite
footcitet
footcitetitle
footfullcite
footnote
Footnote
footnotedesign
footnotediagram
footnotemargin
footnotemark
Footnotemark
footnoterule
footnotesep
footnotesize
footnotetext
Footnotetext
footrule
footrulewidth
footskip
forall
forcefootnotes
foreignlanguage
form
ForwardToIndex
foundername
FourStar
frac
fracwithdelims
frail
frakdefault
frakfamily
fraklines
frame
framebox
FrenchFootnotes
FrenchLayout
frenchspacing
from
frontmatter
frown
Frowny
fullcite
fullref
fussy
fvset
Game
Gamma
gamma
GBP
gcd
generalname
generate
geneuro
geneuronarrow
geneurowide
genfrac
geometry
geq
geqq
geqslant
germanhyphenmins
gets
ggg
gggtr
gimel
global
glossary
glossaryentry
GlossaryMin
glossaryname
GlossaryParms
GlossaryPrologue
glue
gnapprox
gneq
gneqq
gnsim
gothfamily
graphicspath
graphpaper
grave
greekencoding
Greeknumeral
greeknumeral
greektext
grid
Grtoday
gtrapprox
gtrdot
gtreqless
gtreqqless
gtrless
grtsim
guillemotleft
guillemotright
guilsinglleft
guilsinglright
gvertneqq
hangindent
harvarditem
hat
hbadness
hbar
hbox
hdashline
hdots
hdotsfor
headheight
headingdesign
headingdiagram
headrule
headrulewidth
headsep
headtoname
headwidth
heartsuit
heavyrulewidth
hebdate
hebday
hebrew
hebrewencoding
Hebrewtoday
height
help
hfil
hfill
hfuzz
hhline
hline
Hmjd
hodiau
hodiaun
hoffset
hom
hookleftarrow
hookrightarrow
howcitedprefix
howcitedsuffix
hphantom
HRule
hrule
hrulefill
hsize
hslash
hspace
Hsub
Huge
huge
Hut
hyphenation
hyphenchar
hyphenpenalty
ibidemmidname
ibidemname
idemPfname
idempfname
idemPmname
idempmname
idemPnname
idempnname
idemSfname
idemsfname
idemSmname
idemsmname
idemSnname
idemsnname
idotsint
idxitem
IeC
IF
ifbottomfloat
ifcase
ifdim
iffalse
IfFileExists
iffloatpage
ifcase
ifdim
iffalse
IfFileExists
iffloatpage
iffootnote
iflanguage
ifmmode
ifnum
ifthenelse
iftopfloat
ifToplevel
ifx
ignorespaces
iiiint
iiint
iint
imath
implies
include
includegraphics
includeonly
indent
Index
index
indexentry
IndexInput
IndexMin
indexname
IndexParms
IndexPrologue
indexproofstyle
Indextt
inf
infty
init
initfamily
initiate@active@char
injlim
inplus
input
inputencoding
InputIfFileExists
insert
int
intercal
interleave
internallinenumbers
intertext
Interval
intextsep
iota
IroningII
iscurrentchapter
iso
isodd
itdefault
item
itemindent
itemsep
itshape
JackStar
JackStarBold
jbactualauthorfont
jbactualauthorfontifannotator
jbannotatorfont
jbannoteformat
jbauthorfont
jbauthorfontifannotator
jbauthorindexfont
jbbfsasep
jbbibhang
jbbstasep
jbbtasep
jbcitationyearformat
jbignorevarioref
jbindexbib
jbindextype
jbtitlefont
jbuseidemhrule
jbyearaftertitle
jmath
jobname
Joch
Join
joinrel
jot
jput
jurabibsetup
justifying
JustifyingParfillskip
JustifyingParindent
kappa
keepsilent
Ker
ker
Keyboard
kill
l@chapter
l@english
l@example
l@figure
l@paragraph
l@part
l@section
l@subfigure
l@subparagraph
l@subsection
l@subsubsection
l@subtable
l@table
label
labelenumi
labelenumii
labelenumiii
labelenumiv
labelformat
labelitemi
labelitemii
labelitemiii
labelitemiv
labelsep
labelwidth
Lambda
lambda
land
langle
language
languageattribute
languagename
languageshorthands
LARGE
Large
large
largepencil
larger
LastDeclareEncoding
lastdashline
lasthline
lastleftmark
lastleftxmark
lastrightmark
lastrightxmark
latinencoding
latintext
layout
Lbag
lbag
lbrace
lbrack
lceil
Lcs
ldf@finish
LdfInit
ldots
leadsto
left
Leftarrow
leftarrow
leftarrowtail
leftarrowtriangle
leftharpoondown
leftharpoonup
lefthyphenmin
leftleftarrows
leftmargin
leftmark
leftpointright
Leftrightarrow
leftrightarrow
leftrightarroweq
leftrightarrows
leftrightarrowtriangle
leftrightharpoons
leftrightsquigarrow
leftthreetimes
leftroot
leftskip
leftslice
leftthreetimes
leftthumbsdown
leftthumbsup
lengthtest
leq
leqq
leqslant
lessapprox
lessdot
lesseqgtr
lesseqqgtr
lessgtr
lesssim
let
Letter
lettrine
LettrineFontHook
LettrineTextHook
levelchar
lfloor
Lgem
lgem
lgroup
lhd
lhead
lhook
Lightning
lightning
lightrulewidth
lim
liminf
limits
limsup
Line
line
linebreak
linelabel
Lineload
LineNumber
linenumberfont
linenumbers
linenumbersep
linenumberwidth
lineref
lineskip
linespread
linethickness
linewidth
lining
lips
listdesign
listdiagram
listfigurename
listfiles
listof
listofexamples
listoffigures
listoftables
listparindent
listtablename
llap
llbracket
llceil
Lleftarrow
llfloor
lll
llless
llparenthesis
lmoustache
lnapprox
lneq
lneqq
lnot
lnsim
LoadClass
LoadClassWithOptions
log
long
Longarrownot
longarrownot
Longleftarrow
longleftarrow
Longleftrightarrow
longleftrightarrow
Longmapsfrom
longmapsfrom
Longmapsto
longmapsto
longpage
Longrightarrow
longrightarrow
lookatprefix
lookatsuffix
looparrowleft
looparrowright
looseness
lor
lowercase
lozenge
LPNoBreakList
lproject
Lsh
lstinline
lstinputlisting
lstlistingname
lstlistlistingname
lstlistoflistings
lstloadlanguages
lstset
Lsub
LTcapwidth
ltimes
LTleft
LTpost
LTpre
LTright
lvec
lVert
lvert
lvertneqq
m@ne
MacrocodeTopsep
MacroFont
MacroIndent
MacroTopsep
main
mainmatter
makeatletter
makeatother
makebox
makeenmark
makeglossary
makeindex
makelabel
makeLineNumber
makeLineNumberRight
MakeLowercase
MakePercentComment
MakePercentIgnore
MakePerPage
MakePrivateLetters
MakeShortVerb
MakeTextLowercase
MakeTextUppercase
maketitle
MakeUppercase
Mapsfrom
mapsfrom
Mapsfromchar
mapsfromchar
Mapsto
mapsto
Mapstochar
mapstochar
marg
marginlabel
marginpar
marginparpush
marginparsep
marginparswitchfalse
marginparwidth
mark
markboth
markright
mathalpha
mathbb
mathbf
mathbin
mathcal
mathclose
mathdollar
mathellipsis
mathfrak
mathindent
mathinner
mathit
mathlarger
mathnormal
mathop
mathopen
mathord
mathparagraph
mathpunct
mathrel
mathring
mathrm
mathscr
mathsection
mathsf
mathsmaller
mathsterling
mathstrut
mathtt
mathversion
matrixput
max
maxdimen
maxfiles
maxoutfiles
maxovaldiam
mbox
mddefault
mdqoff
mdqon
mdseries
meaning
meas
measuredangle
medmuskip
medskip
medskipamount
medspace
merge
MessageBreak
measuredangle
medskip
meta
MetaPrefix
mho
mid
middle
midrule
midrulesep
midwordellipsis
min
minalignsep
minilof
minilot
minitoc
minus
minuso
MobileFone
mod
models
Module
modulolinenumbers
moo
morecmidrules
Mountain
movetoevenpage
movetooddpage
mpfootnotemark
mpfootnoterule
mrm
msfsl
Msg
mspace
mtcfont
mtcindent
mtcpagenumbers
mtcPfont
mtcrule
mtcSfont
mtcSPfont
mtcSSfont
mtcSSSfont
mtctitle
multfootsep
multicolpretolerance
multicolsep
multicoltolerance
multicolumn
multimap
multiply
multiput
multiputlist
multirow
multirowsetup
multlinegap
myclearpage
MyRot
nabla
name
natural
NAT@close
NAT@date
NAT@idxtxt
NAT@name
NAT@open
natural
ncong
Ndash
nearrow
NeedsTeXFormat
neg
negmedspace
negthickspace
negthinspace
neq
newblock
newboolean
newcites
newcolumntype
newcommand
newcounter
newdatelsorbian
newdateusorbian
newenvironment
newfloat
newfont
newif
newindex
newlength
newline
newpage
newrefformat
newsavebox
newstylenums
newsubfloat
newtheorem
newtheoremstyle
newtie
nexists
nextcitefull
nextcitenotitle
nextcitereset
nextciteshort
ngeq
ngeqq
ngeqslant
ngtr
nintt
niplus
nLeftarrow
nleftarrow
nLeftrightarrow
nleftrightarrow
nleq
nleqq
nleqslant
nless
nmid
nnearrow
nnwarrow
noalign
nobibliography
nobreak
nobreakdash
nobreakspace
NoCaseChange
nochangebars
nocite
nocorr
nocorrlist
noextras
noextrasrussian
nofiles
noibidem
noindent
nointerlineskip
nolimits
nolinebreak
nolinenumbers
nombre
nomtcpagenumbers
nomtcrule
non
nonaheterov
nonfrenchspacing
nonstopmode
nonumber
nopagebreak
nopostamble
nopreamble
noptcrules
norm
normal@char
normalcolor
normalem
normalfont
normalmarginpar
normalsize
not
notag
notesname
notin
nparallel
nparallelslant
nplus
nprec
npreceq
nRightarrow
nrightarrow
nshortmid
nshortparallel
nsim
nsubseteq
nsubseteqq
nsucc
nsucceq
nsupseteq
nsupseteqq
ntriangleleft
ntrianglelefteq
ntrianglelefteqslant
ntriangleright
ntrianglerighteq
ntrianglerighteqslant
numberline
numberwithin
nVDash
nVdash
nvDash
nvdash
nwarrow
oarg
oast
obar
oblong
obslash
ocircle
oday
oddpagelayoutfalse
oddsidemargin
odot
officialeuro
ogreaterthan
oiiint
oiint
oint
olddatelsorbian
olddateusorbian
oldstylenums
olessthan
olips
Omega
omega
ominus
omit
onecolumn
onehalfspacing
OnlyDescription
ontoday
opcit
openin
operatorname
oplus
opt
OptionNotUsed
OrnamentDiamondSolid
oslash
otherbeta
otherOmega
otimes
out
outer
outlfamily
output
oval
Ovalbox
ovalbox
ovee
over
overfullrule
overleftarrow
overleftrightarrow
overset
overwithdelims
owedge
owns
p@enumi
p@enumii
p@enumiii
p@enumiv
PackageError
PackageInfo
PackageInfoNoLine
PackageWarning
PackageWarningNoLine
pagebreak
pagedesign
pagediagram
pagefootnoterule
PageIndex
pagename
pagenumbering
pageref
pagestyle
pagevalues
paperheight
paperwidth
par
paradescriptionlabel
paragraph
paragraphdesign
paragraghdiagram
parallel
ParallelAtEnd
ParallelDot
ParallelLText
ParallelPar
ParallelRText
ParallelUserMidSkip
parbox
parfillskip
parg
parindent
parpic
parsep
parskip
part
partial
partname
partopsep
parttoc
PassOptionsToClass
PassOptionsToPackage
path
pausing
pcharpath
pcheck
Peace
penalty
perp
Pfund
phantom
Phi
phi
phone
PhoneHandset
Pi
pi
piccaption
piccaptioninside
piccaptionoutside
piccaptionside
piccaptiontopside
pichskip
picskip
picsquare
Pifill
Pifont
Piline
Pisymbol
pitchfork
plitemsep
plparsep
plpartopsep
pltopsep
Plus
plus
PlusOutline
pmb
pmod
pod
pointendenum
pointlessenum
polishrz
polishzx
poptabs
possessivecite
postamble
postdisplaypenalty
postmulticols
pounds
preamble
prec
precapprox
preccurlyeq
preceq
precnapprox
precneqq
precnsim
precsim
predisplaypenalty
prefacename
premulticols
presetkeys
pretolerance
prettyref
prevdepth
prime
primo
printbibliography
PrintChanges
printcontents
PrintDescribeEnv
PrintDescribeMacro
PrintEnvName
printheadingsfalse
PrintIndex
printindex
PrintMacroName
printparametersfalse
printtime
processdelayedfloats
ProcessOptions
processoptions
prod
Prog
projlim
proofmodetrue
proofname
propto
protect
protected@edef
providecommand
providehyphenmins
ProvidesClass
ProvidesFile
ProvidesLanguage
ProvidesPackage
ProvideTextCommandDefault
ps@plain
ps@titlepage
Psi
psi
ptcCfont
pushtabs
put
putbib
putfile
qauthor
qed
qedhere
qedsymbol
qquad
quad
quarto
question
quotechar
quotedblbase
quotesinglbase
Radiation
raggedbottom
raggedcolumns
RaggedLeft
raggedleft
RaggedLeftLeftskip
RaggedLeftParfillskip
RaggedLeftParindent
RaggedLeftRightskip
RaggedRight
raggedright
RaggedRightLeftskip
RaggedRightparfillskip
RaggedRightParindent
RaggedRightRightskip
Rain
raisebox
raisetag
rangle
ratio
Rbag
rbag
rbrace
rbrack
rceil
RCS
RCSAuthor
RCSDate
RCSdate
RCSdef
RCSID
rcsInfo
rcsInfoDate
rcsInfoDay
rcsInfoFile
rcsInfoLocker
rcsInfoLongDate
rcsInfoMonth
rcsInfoOwner
rcsInfoRevision
rcsInfoStatus
rcsInfoTime
rcsInfoYear
RCSRawDate
RCSRCSfile
RCSRevision
RCSTime
Re
real
RecordChanges
RecustomVerbatimCommand
RecustomVerbatimEnvironment
Ref
ref
reflectbox
refname
refstepcounter
reftextafter
reftextbefore
reftextcurrent
reftextfaceafter
reftextfacebefore
reftextfaraway
reftextlabelrange
reftextpagerange
reftextvario
relax
relphantom
relscale
relsize
renewcommand
renewenvironment
renewindex
RequirePackage
RequirePackageWithOptions
resetul
resizebox
restriction
restylefloat
resumecontents
reversemarginpar
reversemarginpartrue
RewindToStart
rfloor
rfoot
rgroup
rhd
rhead
rho
rhook
right
Rightarrow
rightarrow
rightarrowtail
rightarrowtriangle
RightDiamond
rightharpoondown
rightharpoonup
righthyphenmin
rightleftarrows
rightleftharpoons
rightmargin
rightmark
rightpointleft
rightrightarrows
rightskip
rightslice
rightsquigarrow
rightthreetimes
rightthumbsdown
rightthumbsup
risingdotseq
rlap
rmdefault
rmfamily
rmoustache
Roman
roman
rotatebox
rotcaption
round
rowcolor
rtbracket
rrceil
rrfloor
Rrightarrow
rrparenthesis
Rsh
RSpercentTolerance
rsquare
Rsub
rtimes
rtimew
rule
rVert
rvert
samepage
sample
sAppendix
savebox
SaveVerb
sbox
sboxrule
sboxsep
scalebox
scdefault
scriptscriptstyle
scriptsize
scriptstyle
scrollmode
scshape
sdim
searrow
sec
secdev
secformat
sectfont
section
sectionbreak
sectionmark
sectlof
sectlot
secttoc
secundo
see
seename
selectfont
selectlanguage
seriesdefault
setboolean
setbox
setcounter
setdefaultenum
setdefaultitem
setdefaultleftmargin
setdepth
setfnsymbol
setfootbox
sethebrew
sethicolor
setkeys
setlabelfont
setlayoutscale
setlength
setmarginsrb
SetMathAlphabet
setminus
setnumberpos
setpapersize
setparametertextfont
setstcolor
setstretch
SetSymbolFont
settodepth
settoheight
settowidth
setul
setulcolor
setuldepth
setxaxis
setxname
setxvaluetype
setyaxis
setyname
sfdefault
sffamily
shabox
shadowbox
shadowsize
shadowthickness
shapedefault
sharp
Shilling
shortsite
shortciteA
shortciteN
shortcites
shortdownarrow
shorthandoff
shorthandon
shortindexingoff
shortindexingon
shortleftarrow
shortmid
shortpage
shortparallel
shortrightarrow
shortstack
shorttableofcontents
shorttoc
shortuparrow
shoveleft
shoveright
show
showbox
showboxbreadth
showboxdepth
showclock
showcols
showgroups
showhyphens
showlists
showoutput
showpage
showprogress
showthe
shrinkheight
sidecaptionrelwidth
sidecaptionsep
sidecaptionvpos
sideset
Sigma
sigma
sim
simeq
sin
singlespacing
sinh
SixFloweOpenCenter
skforoverwritetrue
skip
slash
slashint
sldefault
sloppy
slshape
smaller
smallfrown
smallint
smallmatrix
smallpencil
smallsetminus
smallskip
smallsmile
smash
smile
Smiley
Snow
sobg
sodef
SortIndex
SortNOop
soulaccent
soulomit
soulregister
source
sout
space
spacefactor
spadesuit
spbreve
spcheck
spdddot
spddot
spdot
special
SpecialEnvIndex
SpecialEscapechar
SpecialIndex
SpecialMainEnvIndex
SpecialMainIndex
Specialrule
SpecialUsageIndex
sphat
sphericalangle
SpinDown
SpinUp
spline
splitfootnoterule
SplitNote
sptilde
sqcap
sqcup
sqrt
sqrtsign
sqsubset
sqsubseteq
sqsupset
sqsupseteq
square
SquareShadowC
ssearrow
sslash
sswarrow
stackrel
StandardLayout
star
startcontents
StartFinalBibs
StartShownPreambleCommands
STATE
stcfont
stcindent
stctitle
stepcounter
stockdesign
stockdiagram
stop
stopcontents
StopEventually
StopShownPreambleCommands
StopWatchEnd
StopWatchStart
stretch
string
StrokeFive
strut
subchapter
subfiguresbegin
subfiguresend
subfloat
subitem
subparagraph
subref
subsection
subsectionmark
Subset
subset
subseteq
subseteqq
subsetneq
subsetneqq
subsetplus
subsetpluseq
substack
subsubitem
subsubsection
subtablesbegin
subtablesend
succ
succapprox
succcurlyeq
succeq
succnapprox
succneqq
succnsim
succcsim
sum
Summit
Sun
SunCloud
sup
supminus
supp
suppressfloats
Supset
supset
supseteq
supseteqq
supsetneq
supsetneqq
supsetplus
supsetpluseq
surd
swabfamily
swapnumbers
swarrow
sym
symbol
tablecaption
tablefirsthead
tablehead
tablelasttail
tablename
tableofcontents
tableplace
tablesection
tabletail
tablinesep
tabularnewline
tabularxcolumn
tag
tagcurve
tala
talloblong
tan
tanh
Taschenuhr
tau
tbinom
Telephone
Tent
tertio
text
textacutedbl
textascendercompwordmark
textasciiacute
textasciibreve
textasciicaron
textasciicircum
textasciidieresis
textasciigrave
textasciimarcon
textasciitilde
textasteriskcentered
textbackslash
textbaht
textbar
textbardbl
textbf
textbigcircle
textblack
textblank
textborn
textbraceleft
textbraceright
textbrokenbar
textbullet
textcapitalcompwordmark
textcelsius
textcent
textcentoldstyle
textcircled
textcircledP
textcolonmonetary
textcompsubstdefault
textcompwordmark
textcopyleft
textcopyright
textcurrency
textcyrillic
textdagger
textdaggerdbl
textdblhyphen
textdblhyphenchar
textdegree
textdied
textdiscount
textdiv
textdivorced
textdollar
textdollaroldstyle
textdong
textdownarrow
texteightoldstyle
textellipsis
textemdash
textendash
textepsilon
textestimated
texteuro
textexclamdown
textfiveoldstyle
textfloatsep
textflorin
textfouroldstyle
textfraction
textfractionsolidus
textfrak
textgoth
textgravedbl
textfreater
textgreek
textguarani
textheight
textifsym
textifsymbol
textinit
textinterrobang
textinterrobangdown
textipa
textit
textlangle
textlarger
textlatin
textlbrackdbl
textleaf
textleftarrow
textless
textlira
textlnot
textlquill
textmarried
textmd
textmho
textminus
textmu
textmusicalnote
textnaira
textnineoldstyle
textnormal
textnumero
textogonekcentered
textohm
textol
textonehalf
textoneoldstyle
textonequarter
textonesuperior
textopenbullet
textordfeminine
textordmasculine
textormath
textparagraph
textperiodcentered
textpertenthousand
textperthousand
textpeso
textpilcrow
textpm
textprimstress
textquestiondown
textquotedbl
textquotedblleft
textquotedblright
textquoteleft
textquoteright
textquotesingle
textquotestraightbase
textquotestraightdblbase
textrangle
textrbrackdbl
textrecipe
textreferencemark
textregistered
textrightarrow
textrm
textroundcap
textrquill
textsb
textsc
textscale
textschwa
textsection
textservicemark
textsevenoldstyle
textsf
textsfbf
textsixoldstyle
textsl
textsmaller
textsterling
textstyle
textsuperscript
textsurd
textswab
TextSymbolUnavailable
textthreeoldstyle
textthreequarters
textthreequartersemdash
textthreesuperior
texttildelow
texttimes
texttrademark
texttt
texttwelveudash
texttwooldstyle
texttwosuperior
textunderscore
textup
textuparrow
textupsilon
textvisiblespace
textwidth
textwon
textyen
textzerooldstyle
tfrac
the
thebtauxfile
thechapter
theCodelineNO
thecontentslabel
thecontentspage
theendnote
theendnotes
theenmark
theenumi
theenumii
theenumiii
theenumiv
theequation
theFancyVerbLine
thefigure
thefootnote
thelstlisting
themainfigure
themaintable
themnote
thempfootnote
theoremstyle
thepage
theparentequation
thepart
thepostfig
theposttbl
therefore
Thermo
thesection
thesub
thesubfloatfigure
thesubfloattable
thesubsection
thesubsubsection
thesubtable
Theta
theta
thetable
thetitle
theTitleReference
thevpagerefnum
thickapprox
Thicklines
thicklines
thickmuskip
thicksim
thickspace
thinlines
thinmuskip
thinspace
thisfancypage
thisfancyput
thispagestyle
thmname
thmnote
thmnumber
tilde
time
times
tiny
title
titleclass
titlecontents
titleformat
titlelabel
titleline
titleref
titlerule
titlespacing
titlewidth
tnote
tocdesign
tocdiagram
today
todayRoman
toEng
tolerance
tone
top
topcaption
topfigrule
topfraction
topleftxmark
topmargin
topmark
topnumber
toprightxmark
toprule
topsep
topskip
totalheight
traceoff
traceon
tracingall
tracingassigns
tracingcommands
tracinggroups
tracingifs
tracinglostchars
tracingmacros
tracingmulticols
tracingonline
tracingoutput
tracingpages
tracingprargraphs
tracingrestores
tracingstats
tracingtabularx
triangle
triangledown
triangleleft
trianglelefteq
trianglelefteqslant
triangleeq
triangleright
trianglerighteq
trianglerighteqslant
TriangleUp
truncate
TruncateMarker
try
trycolumnsep
trycolumnseprule
tryevensidemargin
tryfootskip
tryheadheight
tryheadsep
trypaperheight
trypaperwidth
trytextheight
trytextwidth
ttdefault
ttfamily
twlrm
twocolumn
twocolumnlayouttrue
twoheadleftarrow
twoheadrightarrow
tyformat
tymax
tymin
typearea
typein
typeout
ULdepth
ULforem
uline
ULthickness
unboldmath
UndeclareTextCommand
UndefineShortVerb
underaccent
underleftarrow
underleftirghtarrow
underrightarrow
underset
undertilde
unitlength
unkern
unlhd
unrhd
unsethebrew
unskip
Uparrow
uparrow
updatename
updatesep
updefault
upDelta
Updownarrow
updownarrow
upharpoonleft
upharpoonright
uplus
upOmega
uppercase
uproot
upshape
Upsilon
upsilon
upuparrows
UrlBigBreaks
UrlBreaks
urldatecomment
urldef
UrlLeft
UrlNoBreaks
urlprefix
UrlRight
urlstyle
usage
usebox
usecounter
usedir
usefont
UseOption
usepackage
usepostamble
usepreamble
UseTDS
UseTextAccent
UseTextSymbol
UseVerb
UseVerbatim
uuline
uwave
val
value
varbigcirc
varbigtriangledown
varbigtraingleup
varcopyright
varcurlyvee
varcurlywedge
varepsilon
varhat
varinjlim
varkappa
varliminf
varlimsup
varnothing
varoast
varobar
varobslash
varocircle
varodot
varograterthan
varolesstahn
varominus
varoplus
varoslash
varotimes
varovee
varowedge
varphi
varpi
varprojlim
varprojto
varrho
varsigma
varsubsetneq
varsubsetneqq
varsupsetneq
varsupsetneqq
vartheta
vartimes
vartriangle
vartriangleleft
vartriangleright
vbadness
vbox
vcenter
Vdash
vDash
vdash
vdots
vec
Vector
vector
vee
veebar
veqns
Verb
verb
Verbatim
verbatimchar
VerbatimEnvironment
VerbatimFootnotes
VerbatimInput
verbx
VERT
Vert
vert
vfill
Village
Virgo
vitem
vline
voffset
vpageref
vpagerefrange
vphantom
Vref
vref
vrefpagenum
vrefrange
vrule
vspace
Vvdash
wedge
whiledo
whline
widehat
WideMargins
widetilde
widowpenalty
width
wlog
wordsep
wrapoverhang
write
Xi
xi
xleftarrow
xmlcode
xout
xquad
xrightarrow
XSolid
XSolidBold
XSolidBrush
xspace
xspaceskip
xswordsdown
xswordsup
xvec
Ydown
Yingyang
yinipar
Yleft
Yright
Yup
zero
zeta
