/*
 * Decompiled with CFR 0.152.
 */
package appPackage;

import appPackage.FolderPanel;
import appPackage.Logger;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;

public class Globals {
    static DefaultTableModel gameList1;
    static JTable tableGames1;
    static JComboBox driveCombo;
    protected static final String AppVersion = "0.8";
    protected static final boolean DEBUG = true;
    public static final boolean MORE_DEBUG = false;
    protected static final String WBFS_FILE = "WBFS";
    protected static final String WBFS_FILE2 = "WBFS/ISO";
    protected static final String WDF_FILE = "WDF";
    protected static final String WDF_FILE2 = "WDF+ISO";
    protected static final String ISO_FILE = "ISO";
    protected static final String SNEEK_FILE = "SNEEK";
    protected static final String DELETE_FILE = "Delete file";
    protected static final String OS_OSX = "Mac OS X";
    protected static final String OS_LINUX = "Linux";
    protected static final String OS_WIN = "Win";
    protected static final String RunPathOSX = "osx/";
    protected static final String RunPathLinux = "linux/";
    protected static final String RunPathWin = "win\\";
    protected static final String CMDWin = "cmd /c ";
    protected static final String CMDLinux = "gksudo";
    protected static String OS;
    protected static String RunPath;
    protected static String CMDPrev;
    protected static String AbsolutePath;
    protected static String PathSeparator;
    protected static String UserName;
    private static Preferences prefs;
    protected static final String PREF_PROXY_EN = "ProxyEnabled";
    protected static final String PREF_PROXY_ADDRESS = "ProxyAddress";
    protected static final String PREF_PROXY_PORT = "ProxyPort";
    protected static final String PREF_PROXY_HAS_USER = "ProxyHasUser";
    protected static final String PREF_PROXY_USERNAME = "ProxyUsername";
    protected static final String PREF_PROXY_PASSWORD = "ProxyPassword";
    public static boolean proxyEnabled;
    public static String proxyAddress;
    public static String proxyPort;
    public static boolean proxyHasUser;
    public static String proxyUsername;
    public static String proxyPassword;

    public static void initGlobals() {
        OS = System.getProperty("os.name");
        Logger.write("System is \"" + OS + "\"");
        AbsolutePath = System.getProperty("user.dir");
        PathSeparator = System.getProperty("file.separator");
        if (OS.equals(OS_OSX)) {
            RunPath = RunPathOSX;
            CMDPrev = "";
        } else if (OS.startsWith(OS_LINUX)) {
            RunPath = RunPathLinux;
            CMDPrev = CMDLinux;
            UserName = System.getProperty("user.name");
        } else if (OS.startsWith(OS_WIN)) {
            RunPath = RunPathWin;
            CMDPrev = CMDWin;
        }
        Globals.loadPreferences();
    }

    public static void savePreferences(boolean enabled, String address, String port, boolean hasUser, String username, String password) {
        if (prefs == null) {
            prefs = Preferences.userRoot().node("appPackage.WiiJManager");
        }
        prefs.putBoolean(PREF_PROXY_EN, enabled);
        prefs.put(PREF_PROXY_ADDRESS, address);
        prefs.put(PREF_PROXY_PORT, port);
        prefs.putBoolean(PREF_PROXY_HAS_USER, hasUser);
        prefs.put(PREF_PROXY_USERNAME, username);
        prefs.put(PREF_PROXY_PASSWORD, password);
        Logger.write("Preferences saved");
        Globals.loadPreferences();
    }

    public static void loadPreferences() {
        if (prefs == null) {
            prefs = Preferences.userRoot().node("appPackage.WiiJManager");
        }
        proxyEnabled = prefs.getBoolean(PREF_PROXY_EN, false);
        proxyAddress = prefs.get(PREF_PROXY_ADDRESS, "");
        proxyPort = prefs.get(PREF_PROXY_PORT, "8080");
        proxyHasUser = prefs.getBoolean(PREF_PROXY_HAS_USER, false);
        proxyUsername = prefs.get(PREF_PROXY_USERNAME, "");
        proxyPassword = prefs.get(PREF_PROXY_PASSWORD, "");
        Logger.write("Preferences loaded");
        Globals.applyPrefs();
    }

    public static void applyPrefs() {
        if (proxyEnabled) {
            System.setProperty("http.proxySet", "true");
            System.setProperty("http.proxyHost", proxyAddress);
            System.setProperty("http.proxyPort", proxyPort);
            if (proxyHasUser) {
                System.setProperty("http.proxyUser", proxyUsername);
                System.setProperty("http.proxyPassword", proxyPassword);
            }
        } else {
            System.setProperty("http.proxySet", "false");
        }
        Logger.write("Preferences applied");
    }

    public static String[] readDrives() {
        String[] command = new String[]{String.valueOf(RunPath) + "wwt", "find"};
        BufferedReader out = Globals.runCommand(command);
        if (out == null) {
            return null;
        }
        String[] drives = new String[20];
        int count = 0;
        Logger.write("Reading drives");
        try {
            String s;
            while ((s = out.readLine()) != null) {
                Logger.write("Drive \"" + s + "\" found");
                drives[count] = s;
                ++count;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.write(e);
        }
        if (count == 0) {
            Logger.write("No drives found");
        }
        return drives;
    }

    public static ImageIcon createImageIcon(String path) {
        if (Globals.FileExists(path)) {
            return new ImageIcon(path);
        }
        System.err.println("Couldn't find file: " + path);
        Logger.write("Couldn't find file: " + path);
        return null;
    }

    public static ImageIcon createImageIcon(String path, int w, int h) {
        if (Globals.FileExists(path)) {
            return Globals.create_Thumbnail(new ImageIcon(path), w, h);
        }
        Logger.write("Couldn't find file: " + path);
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static ImageIcon create_Thumbnail(ImageIcon img, int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(img.getImage(), 0, 0, w, h, null);
        g2.dispose();
        return new ImageIcon(bi);
    }

    /*
     * Unable to fully structure code
     */
    public static String[][] readTitlesDrive(String drive) {
        games = new String[100][4];
        count = 0;
        Logger.write("Reading titles from WBFS drive");
        command = new String[]{String.valueOf(Globals.RunPath) + "wwt", "ls", "--sections", drive};
        out = Globals.runCommand(command);
        if (out != null) ** GOTO lbl10
        return null;
lbl-1000:
        // 1 sources

        {
            games[count] = game;
            ++count;
lbl10:
            // 2 sources

            ** while ((game = Globals.readDisc((BufferedReader)out)) != null)
        }
lbl11:
        // 1 sources

        return games;
    }

    /*
     * Unable to fully structure code
     */
    public static String[][] readTitlesFolder(String folder) {
        games = new String[100][4];
        count = 0;
        Logger.write("Reading titles from WBFS folder");
        command = new String[]{String.valueOf(Globals.RunPath) + "wit", "list", "--sections", "--recurse=" + folder, "--rdepth=3"};
        out = Globals.runCommand(command);
        if (out != null) ** GOTO lbl10
        return null;
lbl-1000:
        // 1 sources

        {
            games[count] = game;
            ++count;
lbl10:
            // 2 sources

            ** while ((game = Globals.readDisc((BufferedReader)out)) != null)
        }
lbl11:
        // 1 sources

        return games;
    }

    public static String[] readTitleFile(String file) {
        Logger.write("Reading titles from WBFS drive");
        String[] command = new String[]{String.valueOf(RunPath) + "wit", "list", "--sections", file};
        BufferedReader out = Globals.runCommand(command);
        if (out == null) {
            return null;
        }
        String[] game = Globals.readDisc(out);
        return game;
    }

    private static String[] readDisc(BufferedReader out) {
        String[] disc;
        block8: {
            String s;
            disc = null;
            while ((s = out.readLine()) != null && !s.startsWith("[disc")) {
            }
            if (s != null) break block8;
            return null;
        }
        try {
            disc = new String[7];
            String id2 = Globals.getLineStartsWith(out, "id");
            String name = Globals.getLineStartsWith(out, "name");
            String title = Globals.getLineStartsWith(out, "title");
            if (title == null) {
                title = name;
            }
            String reg = Globals.getLineStartsWith(out, "region");
            String size = Globals.getLineStartsWith(out, "size");
            long sz = Long.parseLong(size) / 0x100000L;
            size = String.format("%d Mb", sz);
            String type = Globals.getLineStartsWith(out, "filetype");
            if (type.equals(WBFS_FILE2)) {
                type = WBFS_FILE;
            } else if (type.equals(WDF_FILE2)) {
                type = WDF_FILE;
            }
            String path = Globals.getLineStartsWith(out, "filename");
            disc[0] = id2;
            disc[1] = title;
            disc[2] = type;
            disc[3] = reg;
            disc[4] = size;
            disc[5] = path;
        }
        catch (Exception e) {
            Logger.write(e);
            e.printStackTrace();
        }
        return disc;
    }

    private static String getLineStartsWith(BufferedReader out, String prefix) {
        String s = null;
        try {
            while ((s = out.readLine()) != null && !s.startsWith(prefix)) {
            }
        }
        catch (IOException e) {
            Logger.write(e);
            e.printStackTrace();
        }
        if (s != null) {
            return s.substring(s.indexOf("=") + 1);
        }
        return s;
    }

    public static void addGame(FolderPanel panelA, FolderPanel panelB, GameFormat format) {
        String driveA = panelA.getDrive();
        String driveB = panelB.getDrive();
        String gameID = panelA.getSelectedGameID();
        String gameFormat = WBFS_FILE;
        Logger.write("Adding game");
        if (panelB.gameExists(gameID, gameFormat)) {
            JOptionPane.showMessageDialog(null, "The game already exists in panel " + (panelB.getPanelNumber() + 1), "Error", 0);
            Logger.write("No addition. Game already exists");
            return;
        }
        if (panelA == panelB) {
            String path = panelB.getSelectedGamePath();
            if (OS.startsWith(OS_WIN)) {
                path = Globals.pathToCygwinFormat(path);
            }
            String[] command = new String[]{String.valueOf(RunPath) + "wwt", "-P", "-p", driveB, "ADD", path};
            Logger.write(command);
            BackgroundGameCopy a = new BackgroundGameCopy(command, panelA, panelB, "ADD");
            a.execute();
            return;
        }
        if (Globals.isFolder(driveA) && Globals.isDrive(driveB)) {
            String path = panelA.getSelectedGamePath();
            if (OS.startsWith(OS_WIN)) {
                path = Globals.pathToCygwinFormat(path);
            }
            String[] command = new String[]{String.valueOf(RunPath) + "wwt", "-P", "-p", driveB, "ADD", path};
            BackgroundGameCopy a = new BackgroundGameCopy(command, panelA, panelB, "ADD");
            a.execute();
        } else if (Globals.isDrive(driveA) && Globals.isDrive(driveB)) {
            String path = String.valueOf(panelA.getDrive()) + "/" + gameID;
            String[] command = new String[]{String.valueOf(RunPath) + "wwt", "-P", "-p", driveB, "ADD", path};
            BackgroundGameCopy a = new BackgroundGameCopy(command, panelA, panelB, "ADD");
            a.execute();
        }
    }

    public static void extractGame(FolderPanel panelA, FolderPanel panelB, GameFormat format) {
        String driveA = panelA.getDrive();
        String driveB = panelB.getDrive();
        String gameID = panelA.getSelectedGameID();
        String gameFormat = null;
        Logger.write("Extracting game");
        if (format == GameFormat.WBFS) {
            gameFormat = WBFS_FILE;
        } else if (format == GameFormat.WDF) {
            gameFormat = WDF_FILE;
        } else if (format == GameFormat.ISO) {
            gameFormat = ISO_FILE;
        }
        if (panelB.gameExists(gameID, gameFormat)) {
            JOptionPane.showMessageDialog(null, "The game already exists in panel " + (panelB.getPanelNumber() + 1), "Error", 0);
            Logger.write("No extraction. Game already exists");
            return;
        }
        String name = panelA.getSelectedGameTitle();
        String gameDir = String.valueOf(name) + "[" + gameID + "]";
        gameDir = gameDir.replaceAll("[:?\u00ef\u00bf\u00bd*/<>'\\\"|]", "");
        gameDir = gameDir.replaceAll(" ", "_");
        String full_path = String.valueOf(driveB) + PathSeparator + gameDir;
        String[] makedir = new String[]{"mkdir", full_path};
        Globals.runCommand(makedir);
        if (OS.startsWith(OS_WIN)) {
            full_path = Globals.pathToCygwinFormat(full_path);
        } else if (OS.startsWith(OS_LINUX)) {
            full_path = Globals.pathToLinuxFormat(full_path);
        }
        String[] command = new String[]{String.valueOf(RunPath) + "wwt", "-P", "-p", driveA, "EXTRACT", gameID, "", "-z", "-D", full_path};
        if (format == GameFormat.WBFS) {
            command[6] = "-B";
        } else if (format == GameFormat.WDF) {
            command[6] = "-W";
        } else if (format == GameFormat.ISO) {
            command[6] = "-I";
        }
        BackgroundGameCopy a = new BackgroundGameCopy(command, panelA, panelB, "EXTRACT");
        a.execute();
    }

    public static void copyGame(FolderPanel panelA, FolderPanel panelB, GameFormat format) {
        String gameID = panelA.getSelectedGameID();
        String gameFormatA = panelA.getSelectedGameFormat();
        String gameFormatB = null;
        if (format == GameFormat.WBFS) {
            gameFormatB = WBFS_FILE;
        } else if (format == GameFormat.WDF) {
            gameFormatB = WDF_FILE;
        } else if (format == GameFormat.ISO) {
            gameFormatB = ISO_FILE;
        } else if (format == GameFormat.SNEEK) {
            gameFormatB = SNEEK_FILE;
        }
        if (panelB == null) {
            if (panelA.gameExists(gameID, gameFormatB)) {
                JOptionPane.showMessageDialog(null, "This game with this format already exists in panel " + (panelA.getPanelNumber() + 1), "Error", 0);
                Logger.write("No copy. Game already exists");
                return;
            }
        } else if (panelB.gameExists(gameID, gameFormatB)) {
            JOptionPane.showMessageDialog(null, "This game with this format already exists in panel " + (panelB.getPanelNumber() + 1), "Error", 0);
            Logger.write("No copy. Game already exists");
            return;
        }
        Logger.write("Copying game");
        String name = panelA.getSelectedGameTitle();
        String gameDir = String.valueOf(name) + "[" + gameID + "]";
        gameDir = gameDir.replaceAll("[:?\u00ef\u00bf\u00bd*/<>'\\\"|]", "");
        gameDir = gameDir.replaceAll(" ", "_");
        String out_path = null;
        out_path = panelB != null ? String.valueOf(panelB.getDrive()) + PathSeparator + gameDir + PathSeparator : String.valueOf(Globals.getFolderPath(panelA.getSelectedGamePath())) + PathSeparator;
        String[] makedir = new String[]{"mkdir", out_path};
        Globals.runCommand(makedir);
        String[] command = null;
        if (gameFormatA.equals(gameFormatB)) {
            command = new String[]{"cp", panelA.getSelectedGamePath(), out_path};
            if (OS.startsWith(OS_WIN)) {
                command[0] = "copy";
            }
            panelA.setIndeterminateTask();
        } else {
            String in_path = panelA.getSelectedGamePath();
            if (OS.startsWith(OS_WIN)) {
                out_path = Globals.pathToCygwinFormat(out_path);
            } else if (OS.startsWith(OS_LINUX)) {
                out_path = Globals.pathToLinuxFormat(out_path);
                in_path = Globals.pathToLinuxFormat(in_path);
            }
            command = new String[]{String.valueOf(RunPath) + "wit", "-P", "copy", in_path, "-z", "", "-D", out_path};
            if (format == GameFormat.WBFS) {
                command[7] = String.valueOf(command[7]) + gameID + ".wbfs";
                command[5] = "-B";
            } else if (format == GameFormat.WDF) {
                command[7] = String.valueOf(command[7]) + gameID + ".wdf";
                command[5] = "-W";
            } else if (format == GameFormat.ISO) {
                command[7] = String.valueOf(command[7]) + gameID + ".iso";
                command[5] = "-I";
            } else if (format == GameFormat.SNEEK) {
                command[2] = "extract";
                command[4] = "--sneek";
                command[7] = String.valueOf(command[7]) + "sneek";
                if (OS.startsWith(OS_WIN)) {
                    command[7] = Globals.pathToWindowsFormat(command[7]);
                }
                panelA.setIndeterminateTask();
            }
        }
        BackgroundGameCopy a = new BackgroundGameCopy(command, panelA, panelB, "COPY");
        a.execute();
    }

    public static void deleteGame(FolderPanel panel) {
        String drive = panel.getDrive();
        Logger.write("Deleting game");
        if (Globals.isDrive(drive)) {
            String gameID = panel.getSelectedGameID();
            String[] command = new String[]{String.valueOf(RunPath) + "wwt", "-p", drive, "REMOVE", gameID};
            Globals.runCommand(command);
        } else {
            String path = panel.getSelectedGamePath();
            String[] command = null;
            if (OS.equals(OS_OSX) || OS.equals(OS_LINUX)) {
                String fpath = Globals.getFolderPath(path);
                command = new String[]{"rm", path};
                Globals.runCommand(command);
                command = new String[]{"rmdir", fpath};
                Globals.runCommand(command);
            } else if (OS.startsWith(OS_WIN)) {
                path = Globals.pathToWindowsFormat(path);
                String fpath = Globals.getFolderPath(path);
                command = new String[]{"del", path};
                Globals.runCommand(command);
                command = new String[]{"rmdir", fpath};
                Globals.runCommand(command);
            }
        }
        Logger.write("Game Deleted");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] arrayPrependCMD(String[] cmd) {
        int oldSize = cmd.length;
        String[] newArray = null;
        if (OS.startsWith(OS_WIN)) {
            newArray = new String[oldSize + 2];
            System.arraycopy(cmd, 0, newArray, 2, oldSize);
            newArray[0] = "cmd";
            newArray[1] = "/c";
            return newArray;
        } else {
            if (!OS.equals(OS_LINUX)) return cmd;
            if (!cmd[0].startsWith(RunPathLinux) && cmd[0] != "chown") return cmd;
            String pr = Globals.arrayToString(cmd);
            newArray = new String[]{CMDLinux, pr};
        }
        return newArray;
    }

    private static String arrayToString(String[] cmd) {
        String out = cmd[0];
        int i = 1;
        while (i < cmd.length && cmd[i] != null) {
            out = String.valueOf(out) + " " + cmd[i];
            ++i;
        }
        return out;
    }

    public static boolean FileExists(String path) {
        File a = new File(path);
        return a.exists();
    }

    private static void changeUserOfFolder(String path) {
        String[] changeUser = new String[]{"chown", "-R", UserName, path};
        Globals.runCommand(changeUser);
    }

    public static boolean isDrive(String path) {
        return path.startsWith("/dev/");
    }

    public static boolean isFolder(String path) {
        return !path.startsWith("/dev/");
    }

    public static String pathToCygwinFormat(String path) {
        int ini = path.indexOf(PathSeparator);
        String unit = path.substring(0, ini);
        String pathNoUnit = path.substring(ini);
        String pathBars = pathNoUnit.replace(PathSeparator, "/");
        String fullpath = "/cygdrive/" + unit.toLowerCase().charAt(0) + pathBars;
        return fullpath;
    }

    public static String pathToLinuxFormat(String path) {
        path = path.replaceAll(" ", "\\\\ ");
        path = path.replaceAll("\\[", "\\\\[");
        path = path.replaceAll("]", "\\\\]");
        return path;
    }

    public static String pathToWindowsFormat(String path) {
        int ini = path.indexOf("/", 1) + 1;
        int ini2 = path.indexOf("/", ini);
        String unit = path.substring(ini, ini2);
        String pathNoUnit = path.substring(ini2);
        String pathBars = pathNoUnit.replace("/", PathSeparator);
        String fullpath = String.valueOf(unit) + ":" + pathBars;
        return fullpath;
    }

    public static boolean getCover(String gameID) {
        String region;
        switch (gameID.charAt(3)) {
            case 'E': {
                region = "US";
                break;
            }
            case 'J': {
                region = "JA";
                break;
            }
            case 'K': {
                region = "KO";
                break;
            }
            case 'W': {
                region = "ZH";
                break;
            }
            default: {
                region = "EN";
            }
        }
        OutputStream out = null;
        InputStream in = null;
        String out_path = "covers" + PathSeparator + gameID + ".png";
        boolean well_downloaded = true;
        try {
            int readed;
            URL urlPath = new URL("http://www.wiitdb.com/wiitdb/artwork/cover/" + region + "/" + gameID + ".png");
            Logger.write("Obtaining cover: " + urlPath);
            URLConnection yc = urlPath.openConnection();
            int toRead = yc.getContentLength();
            out = new BufferedOutputStream(new FileOutputStream(out_path));
            in = new BufferedInputStream(yc.getInputStream());
            byte[] buff = new byte[1024];
            int tot_readed = 0;
            while ((readed = in.read(buff)) != -1) {
                out.write(buff, 0, readed);
                tot_readed += readed;
            }
            if (toRead != tot_readed) {
                well_downloaded = false;
                Logger.write("Downloaded bad.Waited:" + toRead + " Readed: " + tot_readed);
            }
            in.close();
            out.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("Downloaded Error: " + e.getMessage());
            Logger.write(e);
            e.printStackTrace();
            well_downloaded = false;
        }
        finally {
            if (!well_downloaded) {
                try {
                    out.close();
                    in.close();
                }
                catch (Exception f) {}
                File f = new File(out_path);
                f.delete();
            }
        }
        return false;
    }

    public static String getFolderPath(String path) {
        String[] decomposed_path = null;
        if (OS.startsWith(OS_WIN)) {
            path = Globals.pathToWindowsFormat(path);
            decomposed_path = path.split(String.valueOf(PathSeparator) + PathSeparator);
        } else if (OS.equals(OS_OSX) || OS.equals(OS_LINUX)) {
            decomposed_path = path.split(PathSeparator);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < decomposed_path.length - 1) {
            if (i != 0) {
                sb.append(PathSeparator);
            }
            sb.append(decomposed_path[i]);
            ++i;
        }
        return sb.toString();
    }

    private static BufferedReader runCommand(String[] command) {
        command = Globals.arrayPrependCMD(command);
        Logger.write(command);
        try {
            Process p = Runtime.getRuntime().exec(command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            return stdInput;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BackgroundGameCopy
    extends SwingWorker<String[], FolderPanel> {
        private FolderPanel panelA;
        private FolderPanel panelB;
        private String[] command;
        private String path = null;

        public BackgroundGameCopy(String[] cmd, FolderPanel pA, FolderPanel pB, String type) {
            this.panelA = pA;
            this.panelB = pB;
            if (type.equals("EXTRACT") || type.equals("COPY")) {
                int i = cmd.length - 1;
                while (i >= 0) {
                    if (cmd[i] != null) {
                        this.path = cmd[i];
                        break;
                    }
                    --i;
                }
            }
            this.command = Globals.arrayPrependCMD(cmd);
        }

        @Override
        public String[] doInBackground() {
            try {
                String line;
                Logger.write(this.command);
                Process p = Runtime.getRuntime().exec(this.command);
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = stdInput.readLine()) != null) {
                    int pos = line.indexOf("%");
                    if (pos == -1) continue;
                    String perc = line.charAt(pos - 2) == ' ' ? line.substring(pos - 1, pos) : line.substring(pos - 2, pos);
                    int per = Integer.valueOf(perc);
                    int tal = line.indexOf("ETA");
                    String outLine = tal != -1 ? String.valueOf(perc) + "% " + line.substring(tal) : String.valueOf(perc) + "%";
                    this.panelA.setPercentage(per, outLine);
                }
                this.panelA.setFinishTask();
                if (this.panelB != null) {
                    this.panelB.refreshTableWithPath(null);
                } else {
                    this.panelA.refreshTableWithPath(null);
                }
                Logger.write("Finished operation");
                if (OS.equals(Globals.OS_LINUX) && this.path != null) {
                    Globals.changeUserOfFolder(this.path);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameFormat {
        WBFS,
        WDF,
        ISO,
        SNEEK;

    }
}

