/*
 * Decompiled with CFR 0.152.
 */
package appPackage;

import appPackage.Globals;
import appPackage.Logger;
import appPackage.WiiJManager;
import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class FolderPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 5905424224524375011L;
    public static final String MissingCover = "MissingCover.jpg";
    JPopupMenu popup;
    JPopupMenu popupDrop;
    JTable tableGames;
    private JLabel jLabel1;
    private JComboBox driveCombo;
    private JScrollPane sp;
    private JLabel progressLabel;
    private JLabel coverImage;
    private JProgressBar progressBar;
    String[] colNamesDisk = new String[]{"ID6", "Name", "Format", "Region", "Size"};
    String[] colNamesFolder = new String[]{"ID6", "Name", "Format", "Region", "Size"};
    protected static final String EXTRACT_TO_WBFS = "Extract to WBFS";
    protected static final String EXTRACT_TO_WDF = "Extract to WDF";
    private JButton jButton_Reload;
    protected static final String EXTRACT_TO_ISO = "Extract to ISO";
    protected static final String CONVERT_TO_WBFS = "Convert to WBFS";
    protected static final String CONVERT_TO_WDF = "Convert to WDF";
    protected static final String CONVERT_TO_ISO = "Convert to ISO";
    protected static final String CONVERT_TO_SNEEK = "Convert to Sneek";
    protected static final String COPY_TO_WBFS = "Copy to WBFS";
    protected static final String COPY_TO_WDF = "Copy to WDF";
    protected static final String COPY_TO_ISO = "Copy to ISO";
    protected static final String COPY_TO_SNEEK = "Copy to Sneek";
    protected static final String ADD_TO_WBFS_DRIVE = "Add to WBFS Partition";
    protected static final String DELETE_FILE = "Delete file";
    protected static final String SELECT_FOLDER = "Select Folder...";
    protected static final String REFRESH_COMBO = "Refresh List";
    private JLabel jLabel2;
    private JLabel folder_path;
    protected static int CoverW = 112;
    protected static int CoverH = 157;
    public PanelType panelType;
    private int nPanel;
    private String[][] gamesTitles;
    private String[] selectedGame;
    private boolean isDropped = false;
    public WiiJManager parent;
    public FolderPanel otherPanel;

    public FolderPanel(int npanel) {
        this.nPanel = npanel;
        this.panelType = PanelType.NONE;
        this.selectedGame = null;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setPreferredSize(new Dimension(400, 450));
            AnchorLayout thisLayout = new AnchorLayout();
            this.setLayout(thisLayout);
            this.jButton_Reload = new JButton();
            this.add((Component)this.jButton_Reload, new AnchorConstraint(32, 901, 78, 621, 1, 1, 1, 1));
            this.jButton_Reload.setText(REFRESH_COMBO);
            this.jButton_Reload.setPreferredSize(new Dimension(112, 21));
            this.jButton_Reload.addActionListener(this);
            this.jLabel1 = new JLabel();
            this.add((Component)this.jLabel1, new AnchorConstraint(38, 296, 70, 18, 1, 1, 1, 1));
            this.jLabel1.setText("Select Folder/Drive");
            this.jLabel1.setPreferredSize(new Dimension(111, 14));
            this.driveCombo = new JComboBox();
            this.driveCombo.setActionCommand("comboDrive");
            this.refreshDriveList();
            this.add((Component)this.driveCombo, new AnchorConstraint(27, 571, 81, 293, 1, 1, 1, 1));
            this.driveCombo.setPreferredSize(new Dimension(111, 24));
            this.tableGames = new JTable(){
                private static final long serialVersionUID = 1L;

                public boolean isCellEditable(int rowIndex, int colIndex) {
                    return false;
                }
            };
            this.tableGames.setAutoResizeMode(4);
            this.tableGames.setFillsViewportHeight(true);
            this.tableGames.setTransferHandler(new TableTransferHandler());
            ListSelectionModel rowSM = this.tableGames.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent evnt) {
                    try {
                        if (evnt.getValueIsAdjusting()) {
                            return;
                        }
                        int row = FolderPanel.this.getSelectedRow();
                        if (row != -1) {
                            FolderPanel.this.selectedGame = FolderPanel.this.getSelectedGameInfo();
                            DefaultTableModel gameList = (DefaultTableModel)FolderPanel.this.tableGames.getModel();
                            String gameID = (String)gameList.getValueAt(row, 0);
                            FolderPanel.this.changeCover(gameID);
                        }
                    }
                    catch (Exception e) {
                        Logger.write("Error updating table");
                        Logger.write(e);
                    }
                }
            });
            this.sp = new JScrollPane(this.tableGames);
            this.add((Component)this.sp, new AnchorConstraint(94, 983, 610, 18, 1, 1, 1, 1));
            this.sp.setPreferredSize(new Dimension(388, 232));
            this.progressBar = new JProgressBar();
            this.add((Component)this.progressBar, new AnchorConstraint(927, 740, 958, 371, 1, 1, 1, 1));
            this.progressBar.setPreferredSize(new Dimension(148, 14));
            this.progressLabel = new JLabel();
            this.add((Component)this.progressLabel, new AnchorConstraint(883, 670, 914, 371, 1, 1, 1, 1));
            this.progressLabel.setText("No Task");
            this.progressLabel.setPreferredSize(new Dimension(120, 14));
            this.coverImage = new JLabel(Globals.createImageIcon("covers" + Globals.PathSeparator + MissingCover, CoverW, CoverH));
            this.add((Component)this.coverImage, new AnchorConstraint(623, 332, 972, 53, 1, 1, 1, 1));
            this.coverImage.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            this.coverImage.setPreferredSize(new Dimension(112, 157));
            this.folder_path = new JLabel();
            this.add((Component)this.folder_path, new AnchorConstraint(665, 966, 696, 371, 1, 1, 1, 1));
            this.folder_path.setPreferredSize(new Dimension(239, 14));
            this.jLabel2 = new JLabel();
            this.add((Component)this.jLabel2, new AnchorConstraint(621, 754, 652, 371, 1, 1, 1, 1));
            this.jLabel2.setText("Selected folder/drive:");
            this.jLabel2.setPreferredSize(new Dimension(154, 14));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshDriveList() {
        if (this.driveCombo.getItemCount() != 0) {
            this.driveCombo.setSelectedIndex(0);
            int i = 0;
            while (i < this.driveCombo.getItemCount()) {
                this.driveCombo.removeItemAt(1);
                ++i;
            }
        } else {
            this.driveCombo.addItem("Select Drive");
        }
        String[] drives = Globals.readDrives();
        if (drives != null) {
            int i = 0;
            while (drives[i] != null) {
                if (drives[i].startsWith("/")) {
                    this.driveCombo.addItem(drives[i]);
                }
                ++i;
            }
            this.driveCombo.addItem(SELECT_FOLDER);
            this.driveCombo.addActionListener(this);
        }
    }

    public int getSelectedRow() {
        block6: {
            block5: {
                try {
                    if (this.tableGames.getRowCount() != 0) break block5;
                    return -1;
                }
                catch (Exception e) {
                    Logger.write("Error!");
                    Logger.write(e);
                    e.printStackTrace();
                    return -1;
                }
            }
            if (this.tableGames.getModel() != null) break block6;
            return -1;
        }
        int row = this.tableGames.getSelectedRow();
        if (row == -1) {
            return row;
        }
        return this.tableGames.convertRowIndexToModel(row);
    }

    public void updatePopUpMenu() {
        if (this.panelType == PanelType.DRIVE) {
            if (this.otherPanel.panelType == PanelType.NONE) {
                this.setPopUpMenu(PopUpMenuType.DRIVE_NULL);
            } else if (this.otherPanel.panelType == PanelType.DRIVE) {
                this.setPopUpMenu(PopUpMenuType.DRIVE_DRIVE);
                this.otherPanel.setPopUpMenu(PopUpMenuType.DRIVE_DRIVE);
            } else if (this.otherPanel.panelType == PanelType.FOLDER) {
                this.setPopUpMenu(PopUpMenuType.DRIVE_FOLDER);
                this.otherPanel.setPopUpMenu(PopUpMenuType.FOLDER_DRIVE);
            }
        } else if (this.panelType == PanelType.FOLDER) {
            if (this.otherPanel.panelType == PanelType.NONE) {
                this.setPopUpMenu(PopUpMenuType.FOLDER_NULL);
            } else if (this.otherPanel.panelType == PanelType.FOLDER) {
                this.setPopUpMenu(PopUpMenuType.FOLDER_FOLDER);
                this.otherPanel.setPopUpMenu(PopUpMenuType.FOLDER_FOLDER);
            } else if (this.otherPanel.panelType == PanelType.DRIVE) {
                this.setPopUpMenu(PopUpMenuType.FOLDER_DRIVE);
                this.otherPanel.setPopUpMenu(PopUpMenuType.DRIVE_FOLDER);
            }
        }
    }

    private void setPopUpMenu(PopUpMenuType format) {
        this.popup = new JPopupMenu();
        JMenuItem m0 = this.nPanel == 0 ? new JMenuItem("To Panel 2") : new JMenuItem("To Panel 1");
        m0.setEnabled(false);
        JMenuItem menu = new JMenuItem("This panel");
        menu.setEnabled(false);
        menu.addActionListener(this);
        this.popup.add(menu);
        menu = new JMenuItem(DELETE_FILE);
        menu.addActionListener(this);
        this.popup.add(menu);
        if (format == PopUpMenuType.DRIVE_DRIVE) {
            this.popup.add(new JSeparator());
            this.popup.add(m0);
            menu = new JMenuItem(ADD_TO_WBFS_DRIVE);
            menu.addActionListener(this);
            this.popup.add(menu);
        } else if (format == PopUpMenuType.DRIVE_FOLDER) {
            this.popup.add(new JSeparator());
            this.popup.add(m0);
            menu = new JMenuItem(EXTRACT_TO_WBFS);
            menu.addActionListener(this);
            this.popup.add(menu);
            menu = new JMenuItem(EXTRACT_TO_WDF);
            menu.addActionListener(this);
            this.popup.add(menu);
            menu = new JMenuItem(EXTRACT_TO_ISO);
            menu.addActionListener(this);
            this.popup.add(menu);
        }
        if (format == PopUpMenuType.FOLDER_NULL || format == PopUpMenuType.FOLDER_FOLDER || format == PopUpMenuType.FOLDER_DRIVE) {
            menu = new JMenuItem(CONVERT_TO_WBFS);
            menu.addActionListener(this);
            this.popup.add(menu);
            menu = new JMenuItem(CONVERT_TO_WDF);
            menu.addActionListener(this);
            this.popup.add(menu);
            menu = new JMenuItem(CONVERT_TO_ISO);
            menu.addActionListener(this);
            this.popup.add(menu);
            menu = new JMenuItem(CONVERT_TO_SNEEK);
            menu.addActionListener(this);
            this.popup.add(menu);
        }
        if (format == PopUpMenuType.FOLDER_FOLDER) {
            this.popup.add(new JSeparator());
            this.popup.add(m0);
            menu = new JMenuItem(COPY_TO_WBFS);
            menu.addActionListener(this);
            this.popup.add(menu);
            menu = new JMenuItem(COPY_TO_WDF);
            menu.addActionListener(this);
            this.popup.add(menu);
            menu = new JMenuItem(COPY_TO_ISO);
            menu.addActionListener(this);
            this.popup.add(menu);
            menu = new JMenuItem(COPY_TO_SNEEK);
            menu.addActionListener(this);
            this.popup.add(menu);
        } else if (format == PopUpMenuType.FOLDER_DRIVE) {
            this.popup.add(new JSeparator());
            this.popup.add(m0);
            menu = new JMenuItem(ADD_TO_WBFS_DRIVE);
            menu.addActionListener(this);
            this.popup.add(menu);
        }
        PopupTableListener ml = new PopupTableListener();
        this.tableGames.addMouseListener(ml);
        this.popupDrop = new JPopupMenu();
        if (format == PopUpMenuType.FOLDER_NULL || format == PopUpMenuType.FOLDER_FOLDER || format == PopUpMenuType.FOLDER_DRIVE) {
            JMenuItem menu2 = new JMenuItem(COPY_TO_WBFS);
            menu2.addActionListener(this);
            this.popupDrop.add(menu2);
            menu2 = new JMenuItem(COPY_TO_WDF);
            menu2.addActionListener(this);
            this.popupDrop.add(menu2);
            menu2 = new JMenuItem(COPY_TO_ISO);
            menu2.addActionListener(this);
            this.popupDrop.add(menu2);
        } else if (format == PopUpMenuType.DRIVE_NULL || format == PopUpMenuType.DRIVE_DRIVE || format == PopUpMenuType.DRIVE_FOLDER) {
            JMenuItem menu3 = new JMenuItem(ADD_TO_WBFS_DRIVE);
            menu3.addActionListener(this);
            this.popupDrop.add(menu3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("comboDrive")) {
            if (this.driveCombo.getSelectedIndex() == 0) return;
            String sel = (String)this.driveCombo.getSelectedItem();
            if (sel.equals(SELECT_FOLDER)) {
                this.driveCombo.setSelectedIndex(0);
                if (Globals.OS.equals("Mac OS X")) {
                    FileDialog fd2 = new FileDialog((Frame)this.parent, "Select a folder", 0);
                    System.setProperty("apple.awt.fileDialogForDirectories", "true");
                    fd2.setVisible(true);
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                    if (fd2.getDirectory() == null) return;
                    String folder = String.valueOf(fd2.getDirectory()) + Globals.PathSeparator + fd2.getFile();
                    this.refreshTableWithPath(folder);
                    this.panelType = PanelType.FOLDER;
                } else {
                    JFileChooser dc = new JFileChooser();
                    dc.setFileSelectionMode(1);
                    if (dc.showOpenDialog(this) != 0) return;
                    File f = dc.getSelectedFile();
                    this.refreshTableWithPath(f.getAbsolutePath());
                    this.panelType = PanelType.FOLDER;
                }
            } else {
                this.refreshTableWithPath((String)this.driveCombo.getSelectedItem());
                this.panelType = PanelType.DRIVE;
            }
            this.updatePopUpMenu();
            this.otherPanel.updatePopUpMenu();
            return;
        } else if (e.getActionCommand().equals(REFRESH_COMBO)) {
            this.refreshDriveList();
            this.otherPanel.refreshDriveList();
            return;
        } else if (e.getActionCommand().equals(DELETE_FILE)) {
            String gameTitle = this.getSelectedGameTitle();
            int response = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete " + gameTitle + "?", "Delete game", 0, 3);
            if (response != 0) return;
            Globals.deleteGame(this);
            this.removeSelectedGame();
            return;
        } else if (e.getActionCommand().equals(EXTRACT_TO_WBFS)) {
            Globals.extractGame(this, this.otherPanel, Globals.GameFormat.WBFS);
            return;
        } else if (e.getActionCommand().equals(EXTRACT_TO_WDF)) {
            Globals.extractGame(this, this.otherPanel, Globals.GameFormat.WDF);
            return;
        } else if (e.getActionCommand().equals(EXTRACT_TO_ISO)) {
            Globals.extractGame(this, this.otherPanel, Globals.GameFormat.ISO);
            return;
        } else if (e.getActionCommand().equals(ADD_TO_WBFS_DRIVE)) {
            if (this.isDropped) {
                Globals.addGame(this, this, Globals.GameFormat.WBFS);
                return;
            } else {
                Globals.addGame(this, this.otherPanel, Globals.GameFormat.WBFS);
            }
            return;
        } else if (e.getActionCommand().equals(CONVERT_TO_WBFS)) {
            if (this.getSelectedGameFormat().equals((Object)Globals.GameFormat.WBFS)) {
                JOptionPane.showMessageDialog(null, "Game already in this format", "Warning", 0);
                return;
            }
            Globals.copyGame(this, null, Globals.GameFormat.WBFS);
            return;
        } else if (e.getActionCommand().equals(CONVERT_TO_WDF)) {
            if (this.getSelectedGameFormat().equals((Object)Globals.GameFormat.WDF)) {
                JOptionPane.showMessageDialog(null, "Game already in this format", "Warning", 0);
                return;
            }
            Globals.copyGame(this, null, Globals.GameFormat.WDF);
            return;
        } else if (e.getActionCommand().equals(CONVERT_TO_ISO)) {
            Globals.copyGame(this, null, Globals.GameFormat.ISO);
            return;
        } else if (e.getActionCommand().equals(CONVERT_TO_SNEEK)) {
            Globals.copyGame(this, null, Globals.GameFormat.SNEEK);
            return;
        } else if (e.getActionCommand().equals(COPY_TO_WBFS)) {
            if (this.isDropped) {
                Globals.copyGame(this, this, Globals.GameFormat.WBFS);
                return;
            } else {
                Globals.copyGame(this, this.otherPanel, Globals.GameFormat.WBFS);
            }
            return;
        } else if (e.getActionCommand().equals(COPY_TO_WDF)) {
            if (this.isDropped) {
                Globals.copyGame(this, this, Globals.GameFormat.WDF);
                return;
            } else {
                Globals.copyGame(this, this.otherPanel, Globals.GameFormat.WDF);
            }
            return;
        } else if (e.getActionCommand().equals(COPY_TO_ISO)) {
            if (this.isDropped) {
                Globals.copyGame(this, this, Globals.GameFormat.ISO);
                return;
            } else {
                Globals.copyGame(this, this.otherPanel, Globals.GameFormat.ISO);
            }
            return;
        } else {
            if (!e.getActionCommand().equals(COPY_TO_SNEEK)) return;
            if (this.isDropped) {
                Globals.copyGame(this, this, Globals.GameFormat.SNEEK);
                return;
            } else {
                Globals.copyGame(this, this.otherPanel, Globals.GameFormat.SNEEK);
            }
        }
    }

    public void refreshTableWithPath(String path) {
        if (path == null) {
            path = this.folder_path.getText();
        }
        if (Globals.isFolder(path)) {
            File f = new File(path);
            ListGamesFolder a = new ListGamesFolder(path);
            this.folder_path.setText(f.getAbsolutePath());
            a.execute();
        } else {
            this.gamesTitles = Globals.readTitlesDrive(path);
            this.folder_path.setText(path);
            DefaultTableModel gameList = new DefaultTableModel(this.colNamesDisk, 0);
            this.tableGames.setModel(gameList);
            int count = 0;
            while (this.gamesTitles[count][0] != null) {
                gameList.addRow(new Object[]{this.gamesTitles[count][0], this.gamesTitles[count][1], this.gamesTitles[count][2], this.gamesTitles[count][3], this.gamesTitles[count][4]});
                ++count;
            }
            this.tableGames.setAutoCreateRowSorter(true);
            this.tableGames.getRowSorter().toggleSortOrder(1);
            this.tableGames.setSelectionMode(0);
            this.tableGames.setTransferHandler(new TableTransferHandler());
        }
    }

    public void changeCover(String gameID) {
        String path = "covers" + Globals.PathSeparator + gameID + ".png";
        boolean good_cover = true;
        if (!Globals.FileExists(path)) {
            good_cover = Globals.getCover(gameID);
        }
        ImageIcon i = !good_cover ? Globals.createImageIcon("covers" + Globals.PathSeparator + MissingCover, CoverW, CoverH) : Globals.createImageIcon(path, CoverW, CoverH);
        this.coverImage.setIcon(i);
    }

    public void removeSelectedGame() {
        int row = this.getSelectedRow();
        this.tableGames.clearSelection();
        try {
            if (row != -1) {
                DefaultTableModel gameList = (DefaultTableModel)this.tableGames.getModel();
                gameList.removeRow(row);
                this.tableGames.updateUI();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private String[] getSelectedGameInfo() {
        int row = this.getSelectedRow();
        DefaultTableModel gameList = (DefaultTableModel)this.tableGames.getModel();
        String gameID = (String)gameList.getValueAt(row, 0);
        String gameFormat = (String)gameList.getValueAt(row, 2);
        int i = 0;
        while (this.gamesTitles[i][0] != null) {
            if (this.gamesTitles[i][0].equals(gameID)) {
                if (this.panelType == PanelType.FOLDER) {
                    if (gameFormat.equals(this.gamesTitles[i][2])) {
                        return this.gamesTitles[i];
                    }
                } else {
                    return this.gamesTitles[i];
                }
            }
            ++i;
        }
        return null;
    }

    public String getSelectedGameID() {
        if (this.selectedGame == null) {
            return null;
        }
        return this.selectedGame[0];
    }

    public String getSelectedGameTitle() {
        if (this.selectedGame == null) {
            return null;
        }
        return this.selectedGame[1];
    }

    public String getSelectedGameFormat() {
        if (this.selectedGame == null) {
            return null;
        }
        return this.selectedGame[2];
    }

    public String getSelectedGamePath() {
        if (this.selectedGame == null) {
            return null;
        }
        return this.selectedGame[5];
    }

    public String getDrive() {
        return this.folder_path.getText();
    }

    public int getPanelNumber() {
        return this.nPanel;
    }

    public boolean gameExists(String gameID, String format) {
        DefaultTableModel gameList = (DefaultTableModel)this.tableGames.getModel();
        int n = gameList.getRowCount();
        int i = 0;
        while (i < n) {
            String id2 = (String)gameList.getValueAt(i, 0);
            if (id2.equals(gameID)) {
                if (this.panelType == PanelType.FOLDER) {
                    String fmt = (String)gameList.getValueAt(i, 2);
                    if (fmt.equals(format)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void setIndeterminateTask() {
        this.progressLabel.setText("Task started");
        this.progressBar.setIndeterminate(true);
    }

    public void setPercentage(int perc, String label) {
        this.progressBar.setValue(perc);
        if (label != null) {
            this.progressLabel.setText(label);
        }
    }

    public void setFinishTask() {
        this.progressLabel.setText("Task finished");
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(false);
    }

    static /* synthetic */ JLabel access$1(FolderPanel folderPanel) {
        return folderPanel.progressLabel;
    }

    static /* synthetic */ JProgressBar access$2(FolderPanel folderPanel) {
        return folderPanel.progressBar;
    }

    static /* synthetic */ void access$3(FolderPanel folderPanel, String[][] stringArray) {
        folderPanel.gamesTitles = stringArray;
    }

    static /* synthetic */ String[][] access$4(FolderPanel folderPanel) {
        return folderPanel.gamesTitles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListGamesFolder
    extends SwingWorker<File, Void> {
        private String path;

        public ListGamesFolder(String p) {
            this.path = p;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public File doInBackground() {
            FolderPanel.access$1(FolderPanel.this).setText("Updating listing");
            FolderPanel.access$2(FolderPanel.this).setIndeterminate(true);
            Logger.write("Reading Titles");
            if (Globals.isFolder(this.path)) {
                gameList = new DefaultTableModel(FolderPanel.this.colNamesFolder, 0);
                FolderPanel.access$3(FolderPanel.this, Globals.readTitlesFolder(this.path));
            } else {
                gameList = new DefaultTableModel(FolderPanel.this.colNamesDisk, 0);
                FolderPanel.access$3(FolderPanel.this, Globals.readTitlesDrive(this.path));
            }
            Logger.write("Updating table");
            try {
                FolderPanel.this.tableGames.setModel(gameList);
            }
            catch (Exception e) {
                Logger.write(e);
                e.printStackTrace();
            }
            count = 0;
            if (FolderPanel.access$4(FolderPanel.this) != null) ** GOTO lbl22
            return null;
lbl-1000:
            // 1 sources

            {
                gameList.addRow(new Object[]{FolderPanel.access$4(FolderPanel.this)[count][0], FolderPanel.access$4(FolderPanel.this)[count][1], FolderPanel.access$4(FolderPanel.this)[count][2], FolderPanel.access$4(FolderPanel.this)[count][3], FolderPanel.access$4(FolderPanel.this)[count][4]});
                ++count;
lbl22:
                // 2 sources

                ** while (FolderPanel.access$4((FolderPanel)FolderPanel.this)[count][0] != null)
            }
lbl23:
            // 1 sources

            FolderPanel.access$2(FolderPanel.this).setIndeterminate(false);
            FolderPanel.access$1(FolderPanel.this).setText("Task Finished");
            FolderPanel.this.tableGames.setAutoCreateRowSorter(true);
            FolderPanel.this.tableGames.getRowSorter().toggleSortOrder(1);
            FolderPanel.this.tableGames.setSelectionMode(0);
            FolderPanel.this.tableGames.setTransferHandler(new TableTransferHandler());
            Logger.write("Table updated");
            return null;
        }

        @Override
        public void done() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PanelType {
        DRIVE,
        FOLDER,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PopUpMenuType {
        DRIVE_NULL,
        DRIVE_DRIVE,
        DRIVE_FOLDER,
        FOLDER_NULL,
        FOLDER_DRIVE,
        FOLDER_FOLDER;

    }

    private class PopupTableListener
    extends MouseAdapter {
        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger() && FolderPanel.this.tableGames.getSelectedRow() != -1) {
                FolderPanel.this.isDropped = false;
                FolderPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseExited(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseClicked(MouseEvent e) {
            this.showPopup(e);
        }
    }

    private class TableTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        private TableTransferHandler() {
        }

        public boolean importData(JComponent comp, Transferable t) {
            String[] m;
            block12: {
                File f;
                block11: {
                    List data;
                    block10: {
                        if (!t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            return false;
                        }
                        data = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        if (data.size() <= 1) break block10;
                        JOptionPane.showMessageDialog(null, "As for now, only single drops work. Sorry", "Multiple files dropped", 2);
                        return false;
                    }
                    f = (File)data.get(0);
                    if (!f.isDirectory()) break block11;
                    JOptionPane.showMessageDialog(null, "You have dropped a directory. Only WBFS/WDF/ISO files can be dropped", "File error", 2);
                    return false;
                }
                m = Globals.readTitleFile(f.getAbsolutePath());
                if (m != null) break block12;
                JOptionPane.showMessageDialog(null, "Only valid WBFS/WDF/ISO files can be dropped", "File error", 2);
                return false;
            }
            try {
                FolderPanel.this.selectedGame = m;
                FolderPanel.this.isDropped = true;
                Point p = FolderPanel.this.tableGames.getMousePosition();
                try {
                    if (FolderPanel.this.popupDrop != null) {
                        FolderPanel.this.popupDrop.show(FolderPanel.this.tableGames, p.x, p.y);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
                System.err.println("Ack! we should not be here.\nBad Flavor.");
            }
            catch (IOException ioe) {
                System.out.println("Something failed during import:\n" + ioe);
            }
            return false;
        }

        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return true;
        }
    }
}

