/*
 * Decompiled with CFR 0.152.
 */
package appPackage;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    private static String logFileName = "log.txt";
    private static FileWriter logFile;
    private static final DateFormat df;

    static {
        df = new SimpleDateFormat("yyyy.MM.dd  hh:mm:ss ");
    }

    private Logger() {
    }

    public static void initLogger() {
        try {
            logFile = new FileWriter(logFileName);
        }
        catch (Exception e) {
            System.out.println(Logger.stack2string(e));
        }
    }

    public static void write(String msg) {
        if (logFile == null) {
            return;
        }
        try {
            Date now = new Date();
            String currentTime = df.format(now);
            logFile.write(String.valueOf(currentTime) + " : " + msg + System.getProperty("line.separator"));
            System.out.println(msg);
            logFile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void write(String[] msg) {
        if (logFile == null) {
            return;
        }
        try {
            Date now = new Date();
            String currentTime = df.format(now);
            logFile.write(String.valueOf(currentTime) + " : ");
            int i = 0;
            while (i < msg.length) {
                logFile.write(String.valueOf(msg[i]) + " ");
                System.out.print(String.valueOf(msg[i]) + " ");
                ++i;
            }
            logFile.write(System.getProperty("line.separator"));
            System.out.print(System.getProperty("line.separator"));
            logFile.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void write(Exception e) {
        if (logFile == null) {
            return;
        }
        try {
            Date now = new Date();
            String currentTime = df.format(now);
            logFile.write(String.valueOf(currentTime) + " : " + Logger.stack2string(e) + System.getProperty("line.separator"));
            logFile.flush();
        }
        catch (Exception e0) {
            e0.printStackTrace();
        }
    }

    private static String stack2string(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "------\r\n" + sw.toString() + "------\r\n";
        }
        catch (Exception e2) {
            return "bad stack2string";
        }
    }
}

