# (c) Copyright 2005-2008, 2010, 2012. CodeWeavers, Inc.
package CXAssocKDEXDG;
use warnings;
use strict;
use CXAssoc;
use base "CXAssoc";

use CXLog;
use CXMimeKDE;



#####
#
# Association desktop file helper functions
#
#####

sub create_association($$$$)
{
    my ($self, $massoc, $adata, $extensions)=@_;

    # Save the list of KDE MIME types so CXAssocXDG can associate with them too
    $massoc->{_kdexdg_all_mimes}=$adata->{all_mimes};
    $massoc->{_kdexdg_default_mimes}=$adata->{default_mimes};
    $massoc->{_kdexdg_id}="KDE/" if ($ENV{CX_TAGALL});
    return 1;
}

sub query_association($$$$)
{
    my ($self, $massoc, $adata, $state)=@_;

    # Save the list of KDE MIME types so query_association() takes them into
    # account in CXAssocXDG
    $massoc->{_kdexdg_all_mimes}=$adata->{all_mimes};
    $massoc->{_kdexdg_default_mimes}=$adata->{default_mimes};
    return $state;
}

sub delete_association($$$)
{
    # CXAssocXDG does not use the MIME type list so there is no need to
    # save it here
    return 1;
}



#####
#
# Main
#
#####

sub detect($$$$)
{
    my ($class, $cxoptions, $cxconfig, $gui_info)=@_;
    return () if (!$gui_info->{kde_on} or
                  !$gui_info->{xdg_mime_on} or
                  !$gui_info->{kde_preferred_mime});

    my $self={
        mime           => $gui_info->{kde_preferred_mime},
        mimes          => CXMimeKDE->get("xdg", $cxoptions, $gui_info),
        case_sensitive => 1,
        domain         => "xdg",
        do_assoc       => 1
    };
    bless $self, $class;

    return ($self);
}

sub id($)
{
    my ($self)=@_;
    my $id="CXAssocKDEXDG/$self->{mime}";
    $id =~ s%/+%/%g;
    return $id;
}

sub preinstall($$)
{
    my ($self, $massoc)=@_;
    return $self->{mimes}->collect_unix_extensions($massoc);
}

sub install($$)
{
    my ($self, $massoc)=@_;
    return $self->action($self->{mimes}, $massoc, "install");
}

sub query($$)
{
    my ($self, $massoc)=@_;

    if (!$massoc)
    {
        my $id=$self->id();
        return {mime      => $id,
                partial   => $id};
    }
    return $self->action($self->{mimes}, $massoc, "query");
}

sub uninstall($$)
{
    my ($self, $massoc)=@_;
    return $self->action($self->{mimes}, $massoc, "uninstall");
}

sub removeall($$)
{
    my ($self, $pattern)=@_;
    $self->{mimes}->removeall($self->{domain}, $pattern);
    return 1;
}

sub finalize($)
{
    my ($self)=@_;
    return $self->{mimes}->finalize();
}

return 1;
